#ifndef SOLITON_PCITG_KERNEL_H
#define SOLITON_PCITG_KERNEL_H

#define PCITG_PORT_CTL          0x01
#define PCITG_PORT_A            0x02
#define PCITG_PORT_B            0x04
#define PCITG_PORT_C            0x08
#define PCITG_PORT_ALL          0x0F

#define PCITG_GROUP0            0
#define PCITG_GROUP1            1

#define PCITG_IRQ_EXT           0
#define PCITG_IRQ_B0            1
#define PCITG_IRQ_A0            2
#define PCITG_IRQ_B1            4
#define PCITG_IRQ_A1            8

#ifdef __KERNEL__

#include <linux/pci.h>
#include <linux/signal.h>


#define PCITG_MAX_BOARD		32

#define PCITG_VENDOR_ID			0x534e
#define PCITG_DEVICE_ID			0x8255
#define PCITG_SUBSYSTEM_VENDOR_ID	0x534e
#define PCITG_SUBSYSTEM_ID		0x0001

#define PCITG_CHIP0_PORT_A(x)	((x)+0x00)
#define PCITG_CHIP0_PORT_B(x)	((x)+0x04)
#define PCITG_CHIP0_PORT_C(x)	((x)+0x08)
#define PCITG_CHIP0_PORT_CTL(x)	((x)+0x0C)
#define PCITG_CHIP1_PORT_A(x)	((x)+0x10)
#define PCITG_CHIP1_PORT_B(x)	((x)+0x14)
#define PCITG_CHIP1_PORT_C(x)	((x)+0x18)
#define PCITG_CHIP1_PORT_CTL(x)	((x)+0x1C)
#define PCITG_IRQ_CTL(x)	((x)+0x20)
#define PCITG_MBOX_OUT(x)	((x)+0x24)
#define PCITG_MBOX_IN(x)	((x)+0x28)

typedef struct pcitg_board {
	struct pci_dev *pci;
	unsigned long base;
	int irq;
	int irqmask;
	int used_count;
	int signo;
	int pid;
	char slotname[16];
} pcitg_board_t;

#endif /* __KERNEL__ */

#endif /* SOLITON_PCITG_KERNEL_H */
