#ifndef SOLITON_PCITG_H
#define SOLITON_PCITG_H


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct pcitg {
	int fd;		// file descriptor
	int id;		// board index
	unsigned char ctl[2];	// latch 8255 current control port value
	struct sigaction sa;
	void (*handler) (struct pcitg *, int);
	char slot[16];
} pcitg_t;

#define PCITG_PORT_CTL		0x01
#define PCITG_PORT_A		0x02
#define PCITG_PORT_B		0x04
#define PCITG_PORT_C		0x08
#define PCITG_PORT_ALL		0x0F

#define PCITG_CHIP0		0
#define PCITG_CHIP1		1

#define PCITG_IRQ_EXT		0
#define PCITG_IRQ_B0		1
#define PCITG_IRQ_A0		2
#define PCITG_IRQ_B1		4
#define PCITG_IRQ_A1		8
#define PCITG_IRQ_ALL		0x0F

#define SIG_PCITG		SIGRTMIN

#define PCITG_ERROR		-1
#define PCITG_OK		0
#define PCITG_NULL		((void *)0)

extern pcitg_t *pcitg_open(const int id);
extern void pcitg_close(pcitg_t *board);
extern char *pcitg_slot_name(pcitg_t *board);

extern int pcitg_in(pcitg_t *board, int chip, int ports, unsigned long *value);
extern int pcitg_out(pcitg_t *board, int chip, int ports, unsigned long value);

extern int pcitg_mbox_in(pcitg_t *board, unsigned char *value);
extern int pcitg_mbox_out(pcitg_t *board, unsigned char value);

extern int pcitg_set_irqmask(pcitg_t *board, int mask);
extern int pcitg_get_irqmask(pcitg_t *board, int *mask);

extern int pcitg_connect(pcitg_t *board, void (*sig_handler) (pcitg_t *, int));

#ifdef __cplusplus
}
#endif

#endif /* SOLITON_PCITG_H */
