#ifndef PCITG_IOCTL_H
#define PCITG_IOCTL_H

#ifdef __cplusplus
extern "C" {
#endif

#include <linux/ioctl.h>

typedef struct iodata_t {
	int chip;
	int addr;
	unsigned value;
} iodata_t;

typedef struct irqdata_t {
	int signo;
	int pid;
} irqdata_t;

#define PCITG_IOC_MAGIC		'T'
#define PCITG_IOC_IN		_IOWR(PCITG_IOC_MAGIC,  1, iodata_t)
#define PCITG_IOC_OUT		_IOW(PCITG_IOC_MAGIC,   2, iodata_t)
#define PCITG_IOC_GET_IRQMASK	_IOWR(PCITG_IOC_MAGIC,  3, int)
#define PCITG_IOC_SET_IRQMASK	_IOW(PCITG_IOC_MAGIC,   4, int)
#define PCITG_IOC_MBOX_IN	_IOWR(PCITG_IOC_MAGIC,  5, unsigned char)
#define PCITG_IOC_MBOX_OUT	_IOW(PCITG_IOC_MAGIC,   6, unsigned char)
#define PCITG_IOC_IRQ_CONNECT	_IOW(PCITG_IOC_MAGIC,   7, int)
#define PCITG_IOC_GET_VECTOR	_IOR(PCITG_IOC_MAGIC,   8, int)
#define PCITG_IOC_SLOTNAME	_IOR(PCITG_IOC_MAGIC,   9, int /* dummy */)


#ifdef __cplusplus
}
#endif

#endif /* PCITG_IOCTL_H */

