#include <pcitg.h>

void sig_handle(pcitg_t *board, int vector)
{
	static int count = 0;
	printf("GOT BOARD %d SIGNAL vector %d: count %d\n",
		board->id, vector, count);
	++count;
	return;
}

int main (int argc, char *argv[])
{
	int id;
	unsigned long value;
	pcitg_t *board;

	if (argc != 2) {
		fprintf(stderr, "usage: %s boardid\n", argv[0]);
		exit(1);
	}

	id = strtol(argv[1], NULL, 0);
	board = pcitg_open(id);
	if (board == PCITG_NULL) {
		fprintf(stderr, "pcitg_open \"board%s\" failed\n", argv[1]); 
		exit(1);
	}
	printf("open pcitg at slot %s\n", pcitg_slot_name(board));
	if (pcitg_connect (board, NULL) == PCITG_ERROR) {
		fprintf(stderr, "pcitg_connect failed\n");
		goto error;
	}
	int status;
#if 0

//	status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_CTL, 0x80);

	value = 0xff;
//	printf("out value=0x%02x\n", value);
	status = pcitg_out(board, PCITG_CHIP0, PCITG_PORT_A, value);
	status = pcitg_out(board, PCITG_CHIP0, PCITG_PORT_B, value);
	status = pcitg_out(board, PCITG_CHIP0, PCITG_PORT_C, value);
//	status = pcitg_out(board, PCITG_CHIP0, PCITG_PORT_ALL, 0xFFFFFF80);
	usleep(500000);

	unsigned long rval;
	pcitg_in (board, PCITG_CHIP0, PCITG_PORT_A, &rval);
	printf("rval=0x%02x\n", rval);
	pcitg_in (board, PCITG_CHIP0, PCITG_PORT_B, &rval);
	printf("rval=0x%02x\n", rval);
	pcitg_in (board, PCITG_CHIP0, PCITG_PORT_C, &rval);
	printf("rval=0x%02x\n", rval);
	value = 0x00;
//	printf("out value=0x%02x\n", value);
	status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_A, value);
	status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_B, value);
	status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_C, value);
//	status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_ALL, 0x00000080);
#endif
	for (;;) {
		int status;

		value = 0xFF;
		status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_A, value);
		status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_B, value);
		status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_C, value);
		usleep(500000);

		value = 0x00;
		status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_A, value);
		status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_B, value);
		status = pcitg_out (board, PCITG_CHIP0, PCITG_PORT_C, value);

		usleep(500000);
	}
	pcitg_close(board);

	exit(0);
error:
	if (board) pcitg_close(board);
	exit(1);
}

