#include <pcitg.h>

void sig_handle(pcitg_t *board, int vector)
{
	static int count = 0;

	pcitg_out(board, PCITG_CHIP0, PCITG_PORT_C, 0);
	pcitg_out(board, PCITG_CHIP1, PCITG_PORT_C, 0);

	printf("GOT BOARD %d SIGNAL vector %d: count %d\n",
		board->id, vector, count);
	++count;
	return;
}

int main (int argc, char *argv[])
{
	int id;
	unsigned long value;
	pcitg_t *board;

	if (argc != 2) {
		fprintf(stderr, "usage: %s boardid\n", argv[0]);
		exit(1);
	}

	id = strtol(argv[1], NULL, 0);
	board = pcitg_open(id);
	if (board == PCITG_NULL) {
		fprintf(stderr, "pcitg_open \"board%s\" failed\n", argv[1]); 
		exit(1);
	}
	printf("open pcitg at slot %s\n", pcitg_slot_name(board));
/*
	if (pcitg_connect (board, sig_handle) == PCITG_ERROR) {
		fprintf(stderr, "pcitg_connect failed\n");
		goto error;
	}
*/

	pcitg_set_irqmask(board, PCITG_IRQ_ALL);

	for (;;) {
		usleep(10000);
                pcitg_out(board, PCITG_CHIP0, PCITG_PORT_C, 0x01);

		usleep(10000);
                pcitg_out(board, PCITG_CHIP0, PCITG_PORT_C, 0x08);

		usleep(10000);
                pcitg_out(board, PCITG_CHIP1, PCITG_PORT_C, 0x01);

		usleep(10000);
                pcitg_out(board, PCITG_CHIP1, PCITG_PORT_C, 0x08);

		usleep(10000);
                pcitg_out(board, PCITG_CHIP0, PCITG_PORT_C, 0);
                pcitg_out(board, PCITG_CHIP1, PCITG_PORT_C, 0);

	}

	pcitg_close(board);

	exit(0);
error:
	if (board) pcitg_close(board);
	exit(1);
}

