#ifndef __SOLITON_PcitgDJ_h__
#define __SOLITON_PcitgDJ_h__



#define PCITG_PORT_CTL 0x01
#define PCITG_PORT_A 0x02
#define PCITG_PORT_B 0x04
#define PCITG_PORT_C 0x08
#define PCITG_PORT_ALL 0x0F
//#define PCITG_PORT_MBOX 0x10

#define PCITG_CHIP0 0
#define PCITG_CHIP1 1
#define PCITG_MBOX 2

//#define PCITC_INTCTL 0x20
#define PCITG_IRQ_EXT		0
#define PCITG_IRQ_B0		1
#define PCITG_IRQ_A0		2
#define PCITG_IRQ_B1		4
#define PCITG_IRQ_A1		8
#define PCITG_INT_MBI4		0x01
#define PCITG_INT_MBI5		0x02
#define PCITG_INT_MBI6		0x04
#define PCITG_INT_MBI7		0x08


// return ststus
#define PCITG_ERROR 1
#define PCITG_OK 0
#define PCITG_NULL 0

typedef struct  _pcitg_t {
	int index; 
	unsigned char bus;
	unsigned char devfn;	
	unsigned char ctl[2];
	unsigned long badr0;
	unsigned char int_mask;	
	int int_num;
	unsigned char int_line;	
	unsigned short pic_addr;
	unsigned char pic_nmask;
	unsigned char pic_omask;
} *pcitg_t;


int pcitg_open(int index, pcitg_t board);
void  pcitg_close(pcitg_t board);
int pcitg_in(pcitg_t board, int chip, int port, unsigned long *value);
int pcitg_out(pcitg_t board, int chip, int port, unsigned long value);
//int  pcitg_in2(pcitg_t board, int ports, unsigned long *value);
//int  pcitg_out2(pcitg_t board, int ports, unsigned long value);
int  pcitg_mbin(pcitg_t board, unsigned long *value);
int  pcitg_mbout(pcitg_t board, unsigned long value);
int  pcitg_intcin(pcitg_t board, unsigned long *value);
int  pcitg_intcout(pcitg_t board, unsigned long value);
int  pcitg_get_vector(pcitg_t board);
int pcitg_connect(pcitg_t board, unsigned char mask, void *isrroutine, unsigned long size);
int pcitg_disconnect(pcitg_t board);
#endif