//****************************************************************
//	Simple Example for PCITG IO under DOS
//	Compiler: DJGPP V2.00
//	
//	Author : Wit Yang, Soliton Tech. Co. LTD.
//	Date : Apr/15/2004
//	Modification :
//	v1.00.00 : Initial Draft
//	
//****************************************************************

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <pcitg.h>
struct _pcitg_t board0;


int main()
{	
	int status;
	unsigned long data;
	unsigned long x;
	int error = 0;
	int total_error = 0;
	int verbose = 0;
		
	// Open PCITG Handler
	status = pcitg_open(0, &board0);
	if (status != PCITG_OK) return 1;	
	// Set 8255-1 for "all output mode"
	// Set 8255-2 for "all input mode"
	pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_CTL, 0x80);
	pcitg_out(&board0, PCITG_CHIP1, PCITG_PORT_CTL, 0x9B);
	
	printf("Please make sure you'd connect J2 to J3! \nPress Any Key to Continue\n");
	getch();	
		
	for (x=0; x<256; x++)
	{
		pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_A, x);
		pcitg_in(&board0, PCITG_CHIP1, PCITG_PORT_A, &data);
		if (x != data) 
		{
			error++;
			if (verbose) 
			{
				printf("WR=%.2X RD=%.2X\n", (unsigned char)(x & 0xFF), (unsigned char)(data & 0xFF));
				getch();
			}
		}
	}
	if (error > 0) printf("Port A Check Error = %d\n", error);
	else printf("Port A Check Success!\n");
	total_error += error;

	error = 0;
	for (x=0; x<256; x++)
	{
		pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_B, x);
		pcitg_in(&board0, PCITG_CHIP1, PCITG_PORT_B, &data);
		if (x != data)
		{
			error++;
			if (verbose) 
			{
				printf("WR=%.2X RD=%.2X\n", (unsigned char)(x & 0xFF), (unsigned char)(data & 0xFF));
				getch();
			}
		}			
	}
	if (error > 0) printf("Port B Check Error = %d\n", error);
	else printf("Port B Check Success!\n");
	total_error += error;

	error = 0;
	for (x=0; x<256; x++)
	{
		pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_C, x);
		pcitg_in(&board0, PCITG_CHIP1, PCITG_PORT_C, &data);
		if (x != data)
		{
			error++;
			if (verbose) 
			{
				printf("WR=%.2X RD=%.2X\n", (unsigned char)(x & 0xFF), (unsigned char)(data & 0xFF));
				getch();
			}
		}
	}
	if (error > 0) printf("Port C Check Error = %d\n", error);
	else printf("Port C Check Success!\n");
	total_error += error;	
		
	pcitg_close(&board0);	
	return 0;
}