//****************************************************************
//	Simple Example for PCITG interrupt handling under DOS
//	Compiler: DJGPP V2.00
//	
//	Author : Wit Yang, Soliton Tech. Co. LTD.
//	Date : Apr/15/2004
//	Modification :
//	v1.00.00 : Initial Draft
//	
//****************************************************************
//	Note:
//	There are total 5 Interrupt source on PCITG Card.  
//	J4-Pin19: Local INT Request, Negtive Trigger
//	J4-Pin10: MailBox Input 4, Positive Trigger
//	J4-Pin12: MailBox Input 5, Positive Trigger
//	J4-Pin14: MailBox Input 6, Positive Trigger
//	J4-Pin16: MailBox Input 7, Positive Trigger
//	with JP1 ~ JP4 connected, we can take use of the 8255 on board
//	to generate interrupt.

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <pc.h> 
#include <dpmi.h>
#include <go32.h>
#include <pcitg.h>
struct _pcitg_t board0;
volatile int isr_ext = 0;
// ISR Start
void EvmIrqHandler(void)
{
	int intvec;
	unsigned long rval;
	// Reset/Disable PCITG Interrupt
	pcitg_intcin(&board0, &rval);		
	pcitg_intcout(&board0, ((rval & 0x0F) | 0x30));
	pcitg_intcout(&board0, ((rval & 0x0F) | 0xB0));
	// Get INT Vector
	intvec = pcitg_get_vector(&board0);	
	// User ISR Code Start Here
	//------------------------------------------------------------------------
	// Reset External Interrupt Source
	isr_ext++;
	pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_C, 0x00);
	pcitg_out(&board0, PCITG_CHIP1, PCITG_PORT_C, 0x00);	
	printf("Hit ISR [%d] Vector[%d]\n", isr_ext, intvec);	
	pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_A, (isr_ext & 0xFF));	
	// User ISR Code Stop Here
	//------------------------------------------------------------------------	
	// Enable PCITG Interrrupt
	pcitg_intcout(&board0, ((rval & 0x0F) | 0xC0));	
}

void EndIrq(void)
{
}
// ISR END

int main()
{	
	int status;
	int isr_int;
	int stim_cnt;
	unsigned char int_mask;
	
	// Open PCITG Handler
	status = pcitg_open(0, &board0);
	if (status != PCITG_OK) return 1;	
	// Set Both 8255 chips for "all output mode"
	// Port A, Port B, and Port C output to 0x00
	pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_ALL, 0x00000080);
	pcitg_out(&board0, PCITG_CHIP1, PCITG_PORT_ALL, 0x00000080);	
	
	printf("Press Any Key for ISR Test\n");
	getch();
	
	isr_ext = 0;
	isr_int = 0;
	// Connect PCITG Interrupt to Interrupt Service Routine "EvmIrqHandler"
	// and enable all interrupt, "MailBox Input 4~7" and "Local INT Request"
	// Note:
	// MailBox Input 4~7 interrupt are Positive Triggered (Low-to-High)
	// Local INT Request is Negtive Triggered (High-to-Low)
	int_mask = PCITG_INT_MBI4 | PCITG_INT_MBI5 | PCITG_INT_MBI6 | PCITG_INT_MBI7;
	pcitg_connect(&board0, int_mask, EvmIrqHandler, (long)EndIrq - (long)EvmIrqHandler);
		
	stim_cnt = 0;
	while(!kbhit())
	{	
		delay(200);
		// Note:
		// When PCITG Interrupt are enabled and JP1 ~ JP4 are all shunt, 
		// JP1: Chip1 PC0 connected to MailBox Input 4 
		// JP2: Chip1 PC3 connected to MailBox Input 5
		// JP3: Chip2 PC0 connected to MailBox Input 6 
		// JP4: Chip2 PC3 connected to MailBox Input 7 		
		// When we send "high" on these signals, 
		// the PCITG will assert INTA(PCI Bus Signal) to system
		//
		printf("Go Int [%d] \n", isr_int);
		if (stim_cnt == 0)
		{
			pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_C, 0x01);
			stim_cnt = 1;		
		}
		else if (stim_cnt == 1)
		{
			pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_C, 0x08);
			stim_cnt = 2;		
		}
		else if (stim_cnt == 2)
		{
			pcitg_out(&board0, PCITG_CHIP1, PCITG_PORT_C, 0x01);
			stim_cnt = 3;		
		}
		else if (stim_cnt == 3)
		{
			pcitg_out(&board0, PCITG_CHIP1, PCITG_PORT_C, 0x08);
			stim_cnt = 0;		
		}
		// Wait Until ISR done			
		while(isr_int == isr_ext);
		// ISR Had Finished 
		pcitg_out(&board0, PCITG_CHIP0, PCITG_PORT_C, 0);
		pcitg_out(&board0, PCITG_CHIP1, PCITG_PORT_C, 0);				
		// Enable System Interrupt
		outportb(board0.pic_addr, board0.pic_nmask);
		isr_int = isr_ext;			
	}
	// Disbale PCITG and System Interrupt
	pcitg_disconnect(&board0);
	pcitg_close(&board0);
	return 0;
	
}